package ga.view.appstate;

import com.jme3.app.Application;
import com.jme3.app.state.AbstractAppState;
import com.jme3.app.state.AppStateManager;
import com.jme3.asset.AssetManager;
import com.jme3.input.InputManager;
import com.jme3.math.Vector3f;
import com.jme3.post.SceneProcessor;
import com.jme3.renderer.Camera;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.ViewPort;
import com.jme3.system.Timer;

/**
 * This is an extended app state for GUIs.
 * 
 * @since 12.08.2012
 * @author Stephan Dreyer
 */
public class GUIState extends AbstractAppState {
  protected Camera cam;
  protected ViewPort viewPort;
  protected InputManager inputManager;
  protected AssetManager assetManager;
  protected AppStateManager stateManager;
  protected RenderManager renderManager;
  protected Timer timer;

  @Override
  public void setEnabled(final boolean enabled) {
    super.setEnabled(enabled);
    if (viewPort != null) {
      if (enabled) {
        if (!renderManager.getPostViews().contains(viewPort)) {
          viewPort = renderManager.createPostView("Gui", cam);
          viewPort.setClearFlags(false, false, false);
        }
      } else {
        while (viewPort.getProcessors().size() > 0) {
          final SceneProcessor proc = viewPort.getProcessors().get(0);
          viewPort.removeProcessor(proc);
        }

        renderManager.removeMainView(viewPort);
      }
    }
  }

  /**
   * Should be called for the final clean up on exit.
   * 
   * @since 12.08.2012
   * @author Stephan Dreyer
   */
  public void finalCleanUp() {
  }

  @Override
  public void initialize(final AppStateManager stateManager,
      final Application app) {
    super.initialize(stateManager, app);

    this.inputManager = app.getInputManager();
    this.assetManager = app.getAssetManager();
    this.stateManager = stateManager;
    this.timer = app.getContext().getTimer();
    this.renderManager = app.getRenderManager();

    cam = new Camera(app.getContext().getSettings().getWidth(), app
        .getContext().getSettings().getHeight());
    cam.setFrustumPerspective(45f, (float) cam.getWidth() / cam.getHeight(),
        0.1f, 20f);
    cam.setLocation(new Vector3f(0f, 0f, 10f));
    cam.lookAt(Vector3f.ZERO, Vector3f.UNIT_Y);

    viewPort = renderManager.createPostView("Gui", cam);
    viewPort.setClearFlags(false, false, false);
  }

  /**
   * Gets the camera.
   * 
   * @return the camera
   */
  public Camera getCamera() {
    return cam;
  }

}
